/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation;

import com.ldtteam.datagenerators.loot_table.LootTableJson;
import com.ldtteam.datagenerators.loot_table.LootTableTypeEnum;
import com.ldtteam.datagenerators.loot_table.pool.PoolJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryTypeEnum;
import com.ldtteam.datagenerators.loot_table.pool.entry.functions.SetCountFunctionJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.functions.SetNbtFunctionJson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class LootTableBuilder {
    private final List<EntryJson> entries = new ArrayList<EntryJson>();
    private LootTableTypeEnum type = LootTableTypeEnum.GENERIC;
    private int rolls = 1;
    private float bonusRolls = 0.0f;

    @NotNull
    public LootTableBuilder type(LootTableTypeEnum type) {
        this.type = type;
        return this;
    }

    @NotNull
    public LootTableBuilder rolls(int rolls) {
        this.rolls = rolls;
        return this;
    }

    @NotNull
    public LootTableBuilder bonusRolls(float bonusRolls) {
        this.bonusRolls = bonusRolls;
        return this;
    }

    @NotNull
    public LootTableBuilder empty(int weight) {
        this.entries.add(new EntryJson(null, EntryTypeEnum.EMPTY, null, null, false, null, weight, 0));
        return this;
    }

    @NotNull
    public LootTableBuilder item(Item item, int weight) {
        this.entries.add(new EntryJson(null, EntryTypeEnum.ITEM, item.getRegistryName().toString(), null, false, null, weight, 0));
        return this;
    }

    @NotNull
    public LootTableBuilder item(ItemStack stack, int weight) {
        if (!stack.func_190926_b()) {
            ArrayList<Object> functions = new ArrayList<Object>();
            if (stack.func_77942_o()) {
                functions.add(new SetNbtFunctionJson(stack.func_77978_p().toString()));
            }
            if (stack.func_190916_E() > 1) {
                functions.add(new SetCountFunctionJson(stack.func_190916_E()));
            }
            this.entries.add(new EntryJson(null, EntryTypeEnum.ITEM, stack.func_77973_b().getRegistryName().toString(), null, false, functions, weight, 0));
        }
        return this;
    }

    @NotNull
    public LootTableJson build() {
        return new LootTableJson(this.type, Collections.singletonList(new PoolJson(null, this.rolls, this.bonusRolls, this.entries)));
    }
}

